/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.scriptorium.gui.drawings;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.net.URI;
import java.util.List;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import org.homelinux.elabor.scriptorium.ecomponents.Annotation;
import org.homelinux.elabor.scriptorium.ecomponents.Citation;
import org.homelinux.elabor.scriptorium.ecomponents.Comment;
import org.homelinux.elabor.scriptorium.ecomponents.Content;
import org.homelinux.elabor.scriptorium.ecomponents.Crux;
import org.homelinux.elabor.scriptorium.ecomponents.DateToken;
import org.homelinux.elabor.scriptorium.ecomponents.Edition;
import org.homelinux.elabor.scriptorium.ecomponents.EditionComponent;
import org.homelinux.elabor.scriptorium.ecomponents.EditionMapper;
import org.homelinux.elabor.scriptorium.ecomponents.Enunciatio;
import org.homelinux.elabor.scriptorium.ecomponents.Expunctio;
import org.homelinux.elabor.scriptorium.ecomponents.Folium;
import org.homelinux.elabor.scriptorium.ecomponents.Image;
import org.homelinux.elabor.scriptorium.ecomponents.Integratio;
import org.homelinux.elabor.scriptorium.ecomponents.MathConcept;
import org.homelinux.elabor.scriptorium.ecomponents.Name;
import org.homelinux.elabor.scriptorium.ecomponents.Place;
import org.homelinux.elabor.scriptorium.ecomponents.TextPart;
import org.homelinux.elabor.scriptorium.ecomponents.Tongue;
import org.homelinux.elabor.scriptorium.ecomponents.Unit;
import org.homelinux.elabor.scriptorium.ecomponents.ValuedComposite;
import org.homelinux.elabor.scriptorium.ecomponents.Variant;
import org.homelinux.elabor.scriptorium.ecomponents.Work;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.BackgroundImage;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.Drawing;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.styles.StyleSetReference;
import org.homelinux.elabor.scriptorium.ecomponents.visitors.EditionUpgrade;
import org.homelinux.elabor.scriptorium.gui.ComponentObserver;
import org.homelinux.elabor.scriptorium.gui.Preferences;
import org.homelinux.elabor.scriptorium.gui.ScriptoriumDirector;
import org.homelinux.elabor.scriptorium.gui.ScriptoriumSelector;
import org.homelinux.elabor.scriptorium.gui.ScriptoriumStyledDocument;
import org.homelinux.elabor.scriptorium.gui.ScriptoriumTextPane;
import org.homelinux.elabor.scriptorium.gui.TextPanel;
import org.homelinux.elabor.scriptorium.gui.VariantsPanel;
import org.homelinux.elabor.scriptorium.gui.drawings.DefaultDrawingDirector;
import org.homelinux.elabor.scriptorium.gui.drawings.DraftExportDirectorFactory;
import org.homelinux.elabor.scriptorium.gui.drawings.DrawingFrame;
import org.homelinux.elabor.scriptorium.gui.drawings.DrawingPanel;
import org.homelinux.elabor.scriptorium.gui.drawings.DrawingTitleListener;
import org.homelinux.elabor.scriptorium.gui.metadata.MetadataPanel;
import org.homelinux.elabor.scriptorium.gui.variants.VariantPanel;
import org.homelinux.elabor.scriptorium.services.EditionManager;
import org.homelinux.elabor.scriptorium.services.Finder;
import org.homelinux.elabor.tools.MessageCatalog;
import org.homelinux.elabor.ui.UIConstants;

public class DiagramsDrawingFrame
extends DrawingFrame
implements ScriptoriumDirector,
WindowListener,
DrawingTitleListener {
    private static final long serialVersionUID = 1L;
    private String fileMenuLabel;
    private String newLabel;
    private String openLabel;
    private String saveExportLabel;
    private String saveasLabel;
    private String newFileTitleString;
    private String newStylesetTitleString;
    private String editionFileName;
    private String stylesetFileName;
    private String theresADrawingString;
    private String wantSaveString;
    private JMenuItem newJMI;
    private JMenuItem openJMI;
    private JMenuItem saveExportJMI;
    private JMenuItem saveasJMI;
    private Edition edition;

    public DiagramsDrawingFrame() {
        this.setDefaultCloseOperation(0);
        this.addWindowListener(this);
        DefaultDrawingDirector drawingDirector = this.getDrawingDirector();
        drawingDirector.addStyleListener(this);
    }

    @Override
    protected void initLocale() {
        super.initLocale();
        MessageCatalog catalog = new MessageCatalog();
        Preferences preferences = Preferences.getInstance();
        String locale = preferences.getProperty("locale");
        catalog.loadCatalog(this.getClass().getName(), locale);
        this.fileMenuLabel = catalog.translate("fileMenu");
        this.newLabel = catalog.translate("newItem");
        this.openLabel = catalog.translate("openItem");
        this.saveExportLabel = catalog.translate("save_exportItem");
        this.saveasLabel = catalog.translate("saveasItem");
        this.newFileTitleString = catalog.translate("newFileTitle");
        this.newStylesetTitleString = catalog.translate("newStyleset");
        this.theresADrawingString = catalog.translate("theresADrawing");
        this.wantSaveString = catalog.translate("wantSave");
    }

    @Override
    protected void initMenubar() {
        super.initMenubar();
        JMenuBar menuBar = this.getJMenuBar();
        JMenu fileMenu = new JMenu(this.fileMenuLabel);
        this.newJMI = new JMenuItem(this.newLabel);
        this.newJMI.addActionListener(this);
        fileMenu.add(this.newJMI);
        this.openJMI = new JMenuItem(this.openLabel);
        this.openJMI.addActionListener(this);
        fileMenu.add(this.openJMI);
        this.saveExportJMI = new JMenuItem(this.saveExportLabel);
        this.saveExportJMI.addActionListener(this);
        fileMenu.add(this.saveExportJMI);
        this.saveasJMI = new JMenuItem(this.saveasLabel);
        this.saveasJMI.addActionListener(this);
        fileMenu.add(this.saveasJMI);
        menuBar.add((Component)fileMenu, 0);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this.newJMI) {
            if (this.checkSaved()) {
                this.resetOptions();
                this.newDrawing();
            }
        } else if (source == this.openJMI) {
            if (this.checkSaved()) {
                this.resetOptions();
                this.openDrawing();
            }
        } else if (source == this.saveExportJMI) {
            this.saveDrawing(false);
        } else if (source == this.saveasJMI) {
            this.saveDrawing(true);
        } else {
            super.actionPerformed(event);
        }
    }

    @Override
    public void drawingChanged() {
        this.setWindowTitle();
    }

    private void setWindowTitle() {
        DefaultDrawingDirector drawingDirector = this.getDrawingDirector();
        String title = this.editionFileName;
        if (drawingDirector.isEditionChanged()) {
            title = String.valueOf(title) + " *";
        }
        title = String.valueOf(title) + " (";
        title = this.stylesetFileName == null ? String.valueOf(title) + this.newStylesetTitleString : String.valueOf(title) + this.stylesetFileName;
        if (drawingDirector.isStylesetChanged()) {
            title = String.valueOf(title) + " *";
        }
        title = String.valueOf(title) + ")";
        this.setTitle(title);
    }

    public boolean checkSaved() {
        boolean ok = this.checkStylesetSaved();
        if (ok) {
            ok = this.checkDrawingSaved();
        }
        return ok;
    }

    private boolean checkDrawingSaved() {
        boolean modify = true;
        DefaultDrawingDirector director = this.getDrawingDirector();
        if (director.isEditionChanged()) {
            int option = JOptionPane.showConfirmDialog(null, String.valueOf(this.theresADrawingString) + " " + this.wantSaveString, UIConstants.getInstance().warningString, 1);
            if (option == 0) {
                this.saveDrawing(false);
            }
            modify = option != 2;
        }
        return modify;
    }

    private void setDrawingFrame(boolean show) {
        this.setConversionsEnabled(show);
    }

    public void newDrawing() {
        this.edition = new Edition();
        this.editionFileName = this.newFileTitleString;
        this.setupEdition(this.edition);
        this.setDrawingFrame(true);
    }

    private void openDrawing() {
        try {
            EditionManager editionManager = EditionManager.getInstance();
            Edition newEdition = editionManager.loadEdition(null);
            if (newEdition != null) {
                this.edition = newEdition;
                File file = this.edition.getFile();
                this.editionFileName = file.getName();
                this.setupEdition(this.edition);
                this.setDrawingFrame(false);
            }
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            UIConstants uiConstants = UIConstants.getInstance();
            JOptionPane.showMessageDialog(null, String.valueOf(uiConstants.errorOccurredString) + " " + e.getMessage(), uiConstants.errorString, 0);
        }
    }

    private void setupEdition(Edition edition) {
        Drawing drawing;
        EditionUpgrade visitor = new EditionUpgrade();
        visitor.visit(edition);
        DefaultDrawingDirector drawingDirector = this.getDrawingDirector();
        Content content = edition.getContent();
        List<Drawing> drawings = content.getDrawings();
        if (drawings.size() == 0) {
            drawing = new Drawing(content, drawingDirector);
            content.addChild(drawing);
        } else {
            drawing = drawings.get(0);
            drawing.setListener(drawingDirector);
        }
        this.setup(this, drawing);
        drawingDirector.resetEditionChanged();
        this.setWindowTitle();
        this.repaint();
    }

    public void saveDrawing(boolean withName) {
        DraftExportDirectorFactory exportDirectorFactory;
        boolean ok;
        DrawingPanel panel = (DrawingPanel)this.getPanel();
        panel.okAction();
        String suggestedFileName = null;
        EditionManager editionManager = EditionManager.getInstance();
        Content content = this.edition.getContent();
        List<Drawing> drawings = content.getDrawings();
        Drawing drawing = drawings.get(0);
        BackgroundImage backgroundImage = drawing.getBackgroundImage();
        if (backgroundImage != null) {
            URI imageUri = backgroundImage.getUri();
            File backgroundFile = editionManager.getImageFile(imageUri, this.edition);
            String backgroundFileName = backgroundFile.getAbsolutePath();
            int index = backgroundFileName.lastIndexOf(".");
            suggestedFileName = String.valueOf(backgroundFileName.substring(0, index)) + ".xml";
        }
        if (ok = editionManager.saveEdition(this.edition, withName, suggestedFileName, exportDirectorFactory = new DraftExportDirectorFactory())) {
            this.exportDiaDiagram();
            DefaultDrawingDirector drawingDirector = this.getDrawingDirector();
            drawingDirector.resetEditionChanged();
            this.setWindowTitle();
        }
    }

    private void exportDiaDiagram() {
        DrawingPanel panel = (DrawingPanel)this.getPanel();
        panel.okAction();
        File file = this.edition.getFile();
        this.editionFileName = file.getName();
        this.setWindowTitle();
        EditionManager editionManager = EditionManager.getInstance();
        editionManager.export(this.edition, "diagrams.xst", ".dia");
    }

    @Override
    public void stylesetChanged(StyleSetReference styleSet) {
        File ssDefaultFolder = EditionManager.getStylesetDefaultFolder(this.edition);
        File stylesetFile = styleSet.getFile(ssDefaultFolder);
        this.stylesetFileName = stylesetFile == null ? null : stylesetFile.getName();
        this.setWindowTitle();
    }

    @Override
    public Edition getEdition() {
        return this.edition;
    }

    @Override
    public EditionMapper getMapper() {
        return null;
    }

    @Override
    public Finder getFinder() {
        return null;
    }

    @Override
    public ScriptoriumStyledDocument getStyledDocument() {
        return null;
    }

    @Override
    public TextPanel getTextPanel() {
        return null;
    }

    @Override
    public void singleClickOn(ScriptoriumTextPane pane) {
    }

    @Override
    public void doubleClickOn(ScriptoriumTextPane pane) {
    }

    @Override
    public void valueChanged(VariantsPanel panel) {
    }

    @Override
    public void valueChanged(VariantPanel panel) {
    }

    @Override
    public void valueChanged(MetadataPanel panel) {
    }

    @Override
    public <T extends EditionComponent<?>> void valueChanged(ScriptoriumSelector<T> panel) {
    }

    @Override
    public void updateText() {
    }

    @Override
    public void highlightText(int offset, int length) {
    }

    @Override
    public <eN extends EditionComponent<?>> void downgradeComponent(eN component) {
    }

    @Override
    public <vC extends ValuedComposite<?>> void downgradeComponent(vC composite) {
    }

    @Override
    public void downloadEdition(URI uuid) {
    }

    @Override
    public void addComponentObserver(ComponentObserver observer) {
    }

    @Override
    public void removeComponentObserver(ComponentObserver observer) {
    }

    public File getCurrentDirectory() {
        return null;
    }

    @Override
    public void windowOpened(WindowEvent arg0) {
    }

    @Override
    public void windowClosing(WindowEvent arg0) {
        if (this.checkSaved()) {
            this.dispose();
        }
    }

    @Override
    public void windowClosed(WindowEvent arg0) {
    }

    @Override
    public void windowIconified(WindowEvent arg0) {
    }

    @Override
    public void windowDeiconified(WindowEvent arg0) {
    }

    @Override
    public void windowActivated(WindowEvent arg0) {
    }

    @Override
    public void windowDeactivated(WindowEvent arg0) {
    }

    @Override
    public void updateSummaryPanel() {
    }

    @Override
    public void openAnnotationsFrame(Annotation annotation) {
    }

    @Override
    public void openCitationsFrame(Citation citation) {
    }

    @Override
    public void openCommentsFrame(Comment comment) {
    }

    @Override
    public void openCrucesFrame(Crux crux) {
    }

    @Override
    public void openDateTokensFrame(DateToken dateToken) {
    }

    @Override
    public void openDrawingFrame(Drawing drawing) {
    }

    @Override
    public void openEnunciationesFrame(Enunciatio enunciatio) {
    }

    @Override
    public void openExpunctionesFrame(Expunctio expunctio) {
    }

    @Override
    public void openFoliaFrame(Folium folium) {
    }

    @Override
    public void openIntegrationesFrame(Integratio integratio) {
    }

    @Override
    public void openMathConceptsFrame(MathConcept mathConcept) {
    }

    @Override
    public void openNamesFrame(Name name) {
    }

    @Override
    public void openPlacesFrame(Place place) {
    }

    @Override
    public void openTextPartsFrame(TextPart textPart) {
    }

    @Override
    public void openTonguesFrame(Tongue tongue) {
    }

    @Override
    public void openUnitsFrame(Unit unit) {
    }

    @Override
    public void openVariantFrame(Variant variant) {
    }

    @Override
    public void openWorksFrame(Work work) {
    }

    @Override
    public void openImagesFrame(Image image) {
    }

    @Override
    public void openDrawingsFrame(Drawing drawing) {
    }
}

