/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.scriptorium.gui.datetokens;

import java.awt.Color;
import java.util.List;
import javax.swing.border.LineBorder;
import org.homelinux.elabor.scriptorium.ecomponents.Content;
import org.homelinux.elabor.scriptorium.ecomponents.DateToken;
import org.homelinux.elabor.scriptorium.ecomponents.Edition;
import org.homelinux.elabor.scriptorium.gui.EditionNodeRenderer;
import org.homelinux.elabor.scriptorium.gui.OldScriptoriumListArea;
import org.homelinux.elabor.scriptorium.gui.OntologyInitialiser;
import org.homelinux.elabor.scriptorium.gui.ScriptoriumDirector;
import org.homelinux.elabor.scriptorium.gui.datetokens.DateTokenFrame;
import org.homelinux.elabor.ui.GenericSelectionModel;

public class DateTokensPanel
extends OldScriptoriumListArea<DateToken> {
    public static final long serialVersionUID = 1L;
    private DateTokenFrame dateToken_frame;

    public DateTokensPanel() {
        super(false, true, true);
        EditionNodeRenderer renderer = new EditionNodeRenderer(OntologyInitialiser.NULL);
        this.setCellRenderer(renderer);
        LineBorder border = new LineBorder(Color.black);
        this.setBorder(border);
    }

    @Override
    public void setup(ScriptoriumDirector director, DateToken date) {
        Edition edition = director.getEdition();
        Content content = edition.getContent();
        List<DateToken> dateTokens = content.getDateTokens();
        super.setup(director, dateTokens, date);
    }

    private void openDateTokenFrame(int index) {
        if (this.dateToken_frame == null) {
            this.dateToken_frame = new DateTokenFrame();
        }
        GenericSelectionModel<DateToken> model = this.getModel();
        this.dateToken_frame.setup(model, index);
    }

    @Override
    public void addAction() {
    }

    @Override
    public void editAction(int index, DateToken date) {
        this.openDateTokenFrame(index);
    }

    @Override
    public void remAction(int index, DateToken date) {
        GenericSelectionModel model = this.getModel();
        model.removeElementAt(index);
        this.getDirector().downgradeComponent(date);
    }

    @Override
    public boolean closing() {
        if (this.dateToken_frame != null) {
            this.dateToken_frame.dispose();
        }
        return super.closing();
    }
}

