/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.scriptorium.gui.citations;

import java.awt.Color;
import java.util.List;
import javax.swing.border.LineBorder;
import org.homelinux.elabor.scriptorium.ecomponents.Citation;
import org.homelinux.elabor.scriptorium.ecomponents.Content;
import org.homelinux.elabor.scriptorium.ecomponents.Edition;
import org.homelinux.elabor.scriptorium.gui.EditionComponentFrame;
import org.homelinux.elabor.scriptorium.gui.OldScriptoriumListArea;
import org.homelinux.elabor.scriptorium.gui.ScriptoriumDirector;
import org.homelinux.elabor.scriptorium.gui.WindowsFactory;
import org.homelinux.elabor.scriptorium.gui.citations.CitationPanel;
import org.homelinux.elabor.ui.GenericSelectionModel;

public class CitationsPanel
extends OldScriptoriumListArea<Citation> {
    private static final long serialVersionUID = 1L;
    private EditionComponentFrame<Citation, CitationPanel> citation_frame;

    public CitationsPanel() {
        super(false, true, true);
        this.setBorder(new LineBorder(Color.black));
    }

    @Override
    public void setup(ScriptoriumDirector director, Citation citation) {
        Edition edition = director.getEdition();
        Content content = edition.getContent();
        List<Citation> citations = content.getCitations();
        super.setup(director, citations, citation);
    }

    private void openCitationFrame(int index) {
        if (this.citation_frame == null) {
            this.citation_frame = WindowsFactory.getCitationFrame();
        }
        GenericSelectionModel model = this.getModel();
        this.citation_frame.setup(this.getDirector(), (Citation)model.get(index));
    }

    @Override
    public void addAction() {
    }

    @Override
    public void remAction(int index, Citation citation) {
        GenericSelectionModel model = this.getModel();
        model.removeElementAt(index);
        this.getDirector().downgradeComponent(citation);
    }

    @Override
    public void editAction(int index, Citation citation) {
        this.openCitationFrame(index);
    }

    @Override
    public boolean closing() {
        if (this.citation_frame != null) {
            this.citation_frame.dispose();
        }
        return super.closing();
    }
}

