/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.scriptorium.gui;

import java.util.ArrayList;
import java.util.List;
import javax.swing.JList;
import javax.swing.JScrollPane;
import org.homelinux.elabor.scriptorium.ecomponents.EditionComponent;
import org.homelinux.elabor.scriptorium.ecomponents.Ontology;
import org.homelinux.elabor.scriptorium.ecomponents.OntologyClass;
import org.homelinux.elabor.scriptorium.ecomponents.OntologyReference;
import org.homelinux.elabor.scriptorium.ecomponents.OntologyRefererInterface;
import org.homelinux.elabor.scriptorium.gui.ScriptoriumPanel;
import org.homelinux.elabor.ui.DefaultGenericSelectionModel;
import org.homelinux.elabor.ui.GenericSelectionModel;

public abstract class OntologyRefererPanel<EC extends EditionComponent<?>>
extends ScriptoriumPanel<EC> {
    private static final long serialVersionUID = 1L;
    private OntologyRefererInterface referer;
    private Ontology ontology;
    private JList<OntologyClass> ontologyList;
    private GenericSelectionModel<OntologyClass> model;

    public JScrollPane createScrollPane(int selectionMode) {
        this.ontologyList = new JList();
        this.ontologyList.setSelectionMode(selectionMode);
        JScrollPane scrollableList = new JScrollPane(this.ontologyList);
        return scrollableList;
    }

    protected void setReferer(OntologyRefererInterface referer) {
        this.referer = referer;
    }

    protected void setOntology(Ontology ontology) {
        this.ontology = ontology;
        List<OntologyClass> classes = ontology.getClasses();
        DefaultGenericSelectionModel<OntologyClass> ontologies = new DefaultGenericSelectionModel<OntologyClass>(classes);
        this.setOntologyModel(ontologies);
    }

    protected void setOntologyModel(GenericSelectionModel<OntologyClass> model) {
        this.ontologyList.setModel(model);
        this.model = model;
    }

    protected void selectIndices() {
        this.ontologyList.clearSelection();
        List<OntologyReference> references = this.referer.getOntologyReferences();
        for (OntologyReference reference : references) {
            OntologyClass ontologyClass = this.ontology.getOntologyClass(reference);
            int ii = 0;
            while (ii < this.model.getSize()) {
                OntologyClass current = (OntologyClass)this.model.get(ii);
                if (current.equals(ontologyClass)) {
                    this.ontologyList.addSelectionInterval(ii, ii);
                }
                ++ii;
            }
        }
    }

    @Override
    public boolean okAction() {
        super.okAction();
        OntologyClass selection = null;
        int[] selected = this.ontologyList.getSelectedIndices();
        ArrayList<OntologyReference> references = new ArrayList<OntologyReference>();
        int ii = 0;
        while (ii < selected.length) {
            selection = (OntologyClass)this.model.get(selected[ii]);
            EditionComponent<?> component = this.referer.getComponent();
            OntologyReference reference = new OntologyReference(component);
            String id = selection.getId();
            reference.setOntologyId(id);
            references.add(reference);
            ++ii;
        }
        this.referer.setOntologyReferences(references);
        return true;
    }
}

