/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.scriptorium.gui;

import java.awt.Color;
import java.util.List;
import javax.swing.border.LineBorder;
import org.homelinux.elabor.scriptorium.ecomponents.Conspectus;
import org.homelinux.elabor.scriptorium.ecomponents.Edition;
import org.homelinux.elabor.scriptorium.ecomponents.Header;
import org.homelinux.elabor.scriptorium.ecomponents.Witness;
import org.homelinux.elabor.scriptorium.gui.OldScriptoriumListArea;
import org.homelinux.elabor.scriptorium.gui.ScriptoriumDirector;
import org.homelinux.elabor.scriptorium.gui.WitnessFrame;
import org.homelinux.elabor.ui.DefaultGenericSelectionModel;

public class ConspectusPanel
extends OldScriptoriumListArea<Witness> {
    private static final long serialVersionUID = 1L;
    private Conspectus conspectus;
    private DefaultGenericSelectionModel<Witness> witnessesModel;
    private WitnessFrame witnessFrame;

    public ConspectusPanel() {
        super(true, true, true);
        this.setBorder(new LineBorder(Color.black));
    }

    @Override
    public void setup(ScriptoriumDirector director) {
        this.setDirector(director);
        director.addComponentObserver(this);
        Edition edition = director.getEdition();
        Header header = edition.getHeader();
        this.conspectus = header.getConspectus();
        List<Witness> witnesses = this.conspectus.getWitnesses();
        this.witnessesModel = new DefaultGenericSelectionModel<Witness>(witnesses);
        super.setup(this.witnessesModel);
    }

    private void openWitnessFrame(int index) {
        if (this.witnessFrame == null) {
            this.witnessFrame = new WitnessFrame();
        }
        this.witnessFrame.setup(this.conspectus, this.witnessesModel, index);
    }

    @Override
    public void addAction() {
        this.openWitnessFrame(-1);
    }

    @Override
    public void remAction(int index, Witness witness) {
        this.conspectus.removeWitness(witness);
        this.witnessesModel.removeElementAt(index);
    }

    @Override
    public void editAction(int index, Witness witness) {
        this.openWitnessFrame(index);
    }

    @Override
    public boolean closing() {
        if (this.witnessFrame != null) {
            this.witnessFrame.dispose();
        }
        return super.closing();
    }
}

