/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.scriptorium.exports;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.homelinux.elabor.scriptorium.ecomponents.DocumentType;
import org.homelinux.elabor.scriptorium.ecomponents.Edition;
import org.homelinux.elabor.scriptorium.ecomponents.EditionStreamer;
import org.homelinux.elabor.scriptorium.ecomponents.Ontology;
import org.homelinux.elabor.scriptorium.ecomponents.OntologyClass;
import org.homelinux.elabor.scriptorium.exports.AuthorComparator;
import org.homelinux.elabor.scriptorium.exports.DateComparator;
import org.homelinux.elabor.scriptorium.exports.EditionComparator;
import org.homelinux.elabor.scriptorium.exports.ExportProcessor;
import org.homelinux.elabor.scriptorium.exports.HeaderInfo;
import org.homelinux.elabor.scriptorium.exports.IndexInfo;
import org.homelinux.elabor.scriptorium.exports.IndexInfoComparator;
import org.homelinux.elabor.scriptorium.exports.MTeXEditionVisitor;
import org.homelinux.elabor.scriptorium.exports.ReceiverComparator;
import org.homelinux.elabor.scriptorium.exports.TopoComparator;
import org.homelinux.elabor.scriptorium.services.EditionManager;

class MTeXExportProcessor
implements ExportProcessor {
    private static final String INDICE_OPERE = "Indice delle opere";
    private static final String INDICE_LUOGHI = "Indice dei luoghi";
    private static final String INDICE_NOMI = "Indice dei nomi";
    private static final String INDICE_AUTORI = "Indice alfabetico per mittente";
    private static final String INDICE_DESTINATARI = "Indice alfabetico per destinatario";
    private static final String INDICE_CRONOLOGICO = "Indice cronologico";
    private static final String INDICE_TOPOGRAFICO = "Indice topografico";
    private static final DateFormat DATE_FORMAT = DateFormat.getDateInstance(2, Locale.ITALIAN);
    private PrintWriter writer;
    private MTeXEditionVisitor visitor;
    private List<Edition> editions;
    private final EditionManager editionManager = EditionManager.getInstance();
    private final Ontology archivesOntology = this.editionManager.getArchivesOntology();
    private final Comparator<Edition> editionComparator;

    public MTeXExportProcessor() {
        this.visitor = new MTeXEditionVisitor();
        this.editionComparator = new EditionComparator();
    }

    @Override
    public void processEdition(Edition edition, EditionStreamer streamer) {
        this.processEdition(edition);
    }

    @Override
    public void startProcess(File file) throws FileNotFoundException, UnsupportedEncodingException {
        this.writer = new PrintWriter(file, "utf-8");
        this.writer.println("\\documentclass[12pt]{book}");
        this.writer.println("\\usepackage[T1]{fontenc}");
        this.writer.println("\\usepackage[utf8x]{inputenc}");
        this.writer.println("\\PreloadUnicodePage{3}");
        this.writer.println("\\PreloadUnicodePage{31}");
        this.writer.println("\\usepackage{txfonts}");
        this.writer.println("\\usepackage{geometry}");
        this.writer.println("\\geometry{a4paper,tmargin=2cm,bmargin=2cm,lmargin=2cm,rmargin=2cm,twoside}");
        this.writer.println("\\usepackage{ibycus4, latexsym, endnotes, adn, mauro, pagenote}");
        this.writer.println("\\usepackage[greek,italian]{babel}");
        this.writer.println("\\usepackage{xr}");
        this.writer.println("\\FoliumInTesto");
        this.writer.println("\\begin{document}");
        this.writer.println("\\htmlcut");
        this.visitor.setWriter(this.writer);
        this.editions = new ArrayList<Edition>();
    }

    @Override
    public void endProcess() {
        List<IndexInfo> places;
        List<IndexInfo> works;
        List<IndexInfo> names;
        List<HeaderInfo> headers;
        this.printEditions();
        this.writer.println();
        if (this.visitor.hasAnnotations()) {
            this.writer.println("\\Annotazioni");
        }
        if ((headers = this.visitor.getHeaders()).size() > 1) {
            this.printChronIndex(headers);
            this.printAuthIndex(headers);
            this.printRecIndex(headers);
            this.printTopoIndex(headers);
        }
        if (!(names = this.visitor.getNames()).isEmpty()) {
            this.printInfosIndexWithoutRepetitions(names, INDICE_NOMI, true);
        }
        if (!(works = this.visitor.getWorks()).isEmpty()) {
            this.printInfosIndexWithoutRepetitions(works, INDICE_OPERE, false);
        }
        if (!(places = this.visitor.getPlaces()).isEmpty()) {
            this.printInfosIndexWithoutRepetitions(places, INDICE_LUOGHI, false);
        }
        this.writer.println("\\end{document}");
        this.writer.close();
    }

    private void printEditions() {
        Collections.sort(this.editions, this.editionComparator);
        for (Edition edition : this.editions) {
            edition.accept(this.visitor);
        }
    }

    private void printInfosIndexWithoutRepetitions(List<IndexInfo> infos, String title, boolean twocolumn) {
        this.writer.println("\\newpage");
        if (twocolumn) {
            this.writer.println("\\twocolumn");
        } else {
            this.writer.println("\\onecolumn");
        }
        this.writer.println("\\section{" + title + "}");
        this.writer.println("\\begin{description}");
        IndexInfoComparator comparator = new IndexInfoComparator();
        Collections.sort(infos, comparator);
        Iterator<IndexInfo> iterator = infos.iterator();
        IndexInfo first = iterator.next();
        String storedEntry = first.getEntry();
        int storedLetterNumber = first.getLetterNumber();
        boolean storedIncerto = first.isIncerto();
        boolean severalOccurrences = false;
        this.startEntry(storedEntry);
        do {
            IndexInfo info = iterator.next();
            String currentEntry = info.getEntry();
            int currentLetterNumber = info.getLetterNumber();
            boolean currentIncerto = info.isIncerto();
            if (currentEntry.equals(storedEntry)) {
                if (currentLetterNumber == storedLetterNumber) {
                    if (currentIncerto == storedIncerto) {
                        severalOccurrences = true;
                        continue;
                    }
                    this.printLetterNumber(storedLetterNumber, storedIncerto, severalOccurrences);
                    this.writer.print(", ");
                    severalOccurrences = false;
                    storedIncerto = currentIncerto;
                    continue;
                }
                this.printLetterNumber(storedLetterNumber, storedIncerto, severalOccurrences);
                this.writer.print(", ");
                severalOccurrences = false;
                storedIncerto = currentIncerto;
                storedLetterNumber = currentLetterNumber;
                continue;
            }
            this.printLetterNumber(storedLetterNumber, storedIncerto, severalOccurrences);
            this.startEntry(currentEntry);
            severalOccurrences = false;
            storedIncerto = currentIncerto;
            storedLetterNumber = currentLetterNumber;
            storedEntry = currentEntry;
        } while (iterator.hasNext());
        this.printLetterNumber(storedLetterNumber, storedIncerto, severalOccurrences);
        this.writer.println("\\end{description}");
    }

    private void startEntry(String entry) {
        String value = entry.trim().replaceAll("\\[(.*)\\]", "\\\\Bibrif{$1}");
        this.writer.println("\\item[" + value + "]");
    }

    private void printLetterNumber(int letterNumber, boolean incerto, boolean severalOccurrences) {
        String letterNumberString = String.valueOf(letterNumber);
        if (severalOccurrences) {
            letterNumberString = "{\\bf " + letterNumberString + "}";
        }
        if (incerto) {
            letterNumberString = String.valueOf(letterNumberString) + "*";
        }
        this.writer.print(letterNumberString);
    }

    private void handleTitlePage(List<HeaderInfo> headers, String title, Comparator<? super HeaderInfo> comparator) {
        this.writer.println("\\newpage");
        this.writer.println("\\section{" + title + "}");
        Collections.sort(headers, comparator);
    }

    private void startArchive(String archive) {
        this.writer.println("\\subsection{" + archive.trim() + "}");
        String ltabulaStructure = "lllcr";
        this.startLtabula(ltabulaStructure);
    }

    private void printTopoIndex(List<HeaderInfo> headers) {
        String title = INDICE_TOPOGRAFICO;
        TopoComparator comparator = new TopoComparator();
        this.handleTitlePage(headers, title, comparator);
        String prevArchive = null;
        for (HeaderInfo header : headers) {
            String rest;
            String archive;
            String total = header.getId().trim();
            if (header.getType() == DocumentType.PRINTED_COPY) {
                archive = "stampe";
                rest = total;
            } else {
                int index = total.indexOf(",");
                String acronym = total.substring(0, index);
                rest = total.substring(index + 2);
                OntologyClass ontologyClass = this.archivesOntology.getOntologyClassById(acronym);
                archive = ontologyClass == null ? acronym : ontologyClass.getComment();
            }
            if (!archive.equals(prevArchive)) {
                this.endSubSection(prevArchive);
                this.startArchive(archive);
                prevArchive = archive;
            }
            this.printTopoHeader(header, rest);
        }
        this.endSubSection(prevArchive);
    }

    private static String getDateValue(HeaderInfo header) {
        String dateValue = "";
        String dateComment = header.getDateComment();
        if (!dateComment.equals("")) {
            dateValue = dateComment;
        } else {
            Date date = header.getDate();
            dateValue = DATE_FORMAT.format(date);
        }
        return dateValue;
    }

    private void printTopoHeader(HeaderInfo header, String rest) {
        String author = header.getAuthor();
        String receiver = header.getReceiver();
        String dateValue = MTeXExportProcessor.getDateValue(header);
        int order = header.getLetterNumber();
        this.writer.println(String.valueOf(MTeXExportProcessor.seizeField(rest, 4)) + " & " + MTeXExportProcessor.seizeField(author, 4) + " & " + MTeXExportProcessor.seizeField(receiver, 4) + " & " + MTeXExportProcessor.seizeField(dateValue, 3) + " & " + order + " \\\\");
    }

    private void printAuthIndex(List<HeaderInfo> headers) {
        String title = INDICE_AUTORI;
        AuthorComparator comparator = new AuthorComparator();
        this.handleTitlePage(headers, title, comparator);
        String prevAuthor = null;
        for (HeaderInfo header : headers) {
            String author = header.getAuthor();
            if (!author.equals(prevAuthor)) {
                this.endSubSection(prevAuthor);
                this.startPerson(author, "a");
                prevAuthor = author;
            }
            this.printOtherPerson(header, header.getReceiver());
        }
        this.endSubSection(prevAuthor);
    }

    private void endSubSection(String subSection) {
        if (subSection != null) {
            this.endLtabula();
        }
    }

    private void startLtabula(String ltabulaStructure) {
        this.writer.println("\\begin{ltabula}{" + ltabulaStructure + "}");
    }

    private void printLTabulaHeaders(String ltabulaHeaders) {
        this.writer.println(String.valueOf(ltabulaHeaders) + " \\\\");
        this.writer.println("\\endhead \\\\");
    }

    private void endLtabula() {
        this.writer.println("\\end{ltabula}");
    }

    private void printRecIndex(List<HeaderInfo> headers) {
        String title = INDICE_DESTINATARI;
        ReceiverComparator comparator = new ReceiverComparator();
        this.handleTitlePage(headers, title, comparator);
        String prevReceiver = null;
        for (HeaderInfo header : headers) {
            String receiver = header.getReceiver();
            if (!receiver.equals(prevReceiver)) {
                this.endSubSection(prevReceiver);
                this.startPerson(receiver, "da");
                prevReceiver = receiver;
            }
            this.printOtherPerson(header, header.getAuthor());
        }
        this.endSubSection(prevReceiver);
    }

    private void startPerson(String person, String preposition) {
        this.writer.println("\\subsection{" + person.trim() + " " + preposition + "}");
        String ltabulaStructure = "lcr";
        this.startLtabula(ltabulaStructure);
    }

    private void printOtherPerson(HeaderInfo header, String other) {
        String dateValue = MTeXExportProcessor.getDateValue(header);
        int order = header.getLetterNumber();
        this.writer.println(String.valueOf(MTeXExportProcessor.seizeField(other, 8)) + " & " + MTeXExportProcessor.seizeField(dateValue, 6) + " & " + order + " \\\\");
    }

    private void printChronIndex(List<HeaderInfo> headers) {
        String title = INDICE_CRONOLOGICO;
        DateComparator comparator = new DateComparator();
        this.handleTitlePage(headers, title, comparator);
        String ltabulaStructure = "rlll";
        String ltabulaHeaders = "{\\bf n.} & {\\bf mittente} & {\\bf destinatario} & {\\bf data}";
        this.startLtabula(ltabulaStructure);
        this.printLTabulaHeaders(ltabulaHeaders);
        for (HeaderInfo header : headers) {
            this.printChronHeader(header);
        }
        this.endLtabula();
    }

    private void printChronHeader(HeaderInfo header) {
        String dateValue = MTeXExportProcessor.getDateValue(header);
        String author = header.getAuthor();
        String receiver = header.getReceiver();
        int order = header.getLetterNumber();
        this.writer.println(String.valueOf(order) + " & " + MTeXExportProcessor.seizeField(author, 5) + " & " + MTeXExportProcessor.seizeField(receiver, 5) + " & " + MTeXExportProcessor.seizeField(dateValue, 5) + " \\\\");
    }

    private static String seizeField(String field, int width) {
        return "\\begin{minipage}[t]{" + width + "cm}\\raggedright " + field.trim() + "\\end{minipage}";
    }

    @Override
    public void processEdition(Edition edition) {
        this.editions.add(edition);
    }
}

