/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.scriptorium.ecomponents.visitors;

import java.util.List;
import org.homelinux.elabor.scriptorium.ecomponents.Annotation;
import org.homelinux.elabor.scriptorium.ecomponents.Citation;
import org.homelinux.elabor.scriptorium.ecomponents.Comment;
import org.homelinux.elabor.scriptorium.ecomponents.Content;
import org.homelinux.elabor.scriptorium.ecomponents.Crux;
import org.homelinux.elabor.scriptorium.ecomponents.DateToken;
import org.homelinux.elabor.scriptorium.ecomponents.Edition;
import org.homelinux.elabor.scriptorium.ecomponents.EditionComponent;
import org.homelinux.elabor.scriptorium.ecomponents.Enunciatio;
import org.homelinux.elabor.scriptorium.ecomponents.Expunctio;
import org.homelinux.elabor.scriptorium.ecomponents.Folium;
import org.homelinux.elabor.scriptorium.ecomponents.Formula;
import org.homelinux.elabor.scriptorium.ecomponents.Image;
import org.homelinux.elabor.scriptorium.ecomponents.Integratio;
import org.homelinux.elabor.scriptorium.ecomponents.ListItem;
import org.homelinux.elabor.scriptorium.ecomponents.MathConcept;
import org.homelinux.elabor.scriptorium.ecomponents.Name;
import org.homelinux.elabor.scriptorium.ecomponents.Place;
import org.homelinux.elabor.scriptorium.ecomponents.Quadratus;
import org.homelinux.elabor.scriptorium.ecomponents.Reading;
import org.homelinux.elabor.scriptorium.ecomponents.Rectangulus;
import org.homelinux.elabor.scriptorium.ecomponents.Text;
import org.homelinux.elabor.scriptorium.ecomponents.TextNotFoundException;
import org.homelinux.elabor.scriptorium.ecomponents.TextPart;
import org.homelinux.elabor.scriptorium.ecomponents.Tongue;
import org.homelinux.elabor.scriptorium.ecomponents.Unit;
import org.homelinux.elabor.scriptorium.ecomponents.Variant;
import org.homelinux.elabor.scriptorium.ecomponents.VariantItem;
import org.homelinux.elabor.scriptorium.ecomponents.Work;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.Drawing;
import org.homelinux.elabor.scriptorium.ecomponents.visitors.NullEditionVisitor;
import org.homelinux.elabor.scriptorium.ndraft.actions.ComputeAction;
import org.homelinux.elabor.scriptorium.ndraft.actions.StraightLineAction;
import org.homelinux.elabor.scriptorium.ndraft.actions.StraightLineDirectionAction;

public class TextNodeFinder
extends NullEditionVisitor {
    private int offset;
    private int position;
    private Text foundNode;
    private Text next;
    private EditionComponent<?> last;

    private void reset() {
        this.foundNode = null;
        this.next = null;
        this.last = null;
        this.offset = 0;
        this.position = 0;
    }

    public TextNodeFinder() {
        this.reset();
    }

    public Text getComponent() throws TextNotFoundException {
        if (this.foundNode == null) {
            throw new TextNotFoundException(this.last, this.next);
        }
        return this.foundNode;
    }

    private void defaultVisit(EditionComponent<?> node) {
        List<EditionComponent<?>> children = node.getChildrenForTextView();
        if (children != null) {
            for (EditionComponent<?> child : children) {
                this.last = child;
                child.accept(this);
                if (this.position > this.offset) break;
            }
        }
    }

    public void setTarget(int offset) {
        this.reset();
        this.offset = offset;
    }

    @Override
    public void visit(Edition edition) {
        Content content = edition.getContent();
        this.last = edition;
        content.accept(this);
    }

    @Override
    public void visit(Content content) {
        this.defaultVisit(content);
    }

    private void visitDelimitedComponent(EditionComponent<?> component) {
        ++this.position;
        this.defaultVisit(component);
        ++this.position;
    }

    @Override
    public void visit(ListItem list_item) {
        this.position += 2;
        this.defaultVisit(list_item);
    }

    @Override
    public void visit(Expunctio expunctio) {
        this.visitDelimitedComponent(expunctio);
    }

    @Override
    public void visit(Crux crux) {
        this.visitDelimitedComponent(crux);
    }

    @Override
    public void visit(Integratio integratio) {
        ++this.position;
        this.last = integratio;
    }

    @Override
    public void visit(Annotation annotation) {
        ++this.position;
        this.last = annotation;
    }

    @Override
    public void visit(Variant variant) {
        this.visitDelimitedComponent(variant);
    }

    @Override
    public void visit(VariantItem variant_item) {
        this.defaultVisit(variant_item);
    }

    @Override
    public void visit(Reading reading) {
        this.defaultVisit(reading);
    }

    @Override
    public void visit(Name name) {
        this.defaultVisit(name);
    }

    @Override
    public void visit(Place place) {
        this.defaultVisit(place);
    }

    @Override
    public void visit(Tongue tongue) {
        this.defaultVisit(tongue);
    }

    @Override
    public void visit(MathConcept mathConcept) {
        this.defaultVisit(mathConcept);
    }

    @Override
    public void visit(DateToken date) {
        this.defaultVisit(date);
    }

    @Override
    public void visit(Enunciatio enunciatio) {
        this.defaultVisit(enunciatio);
    }

    @Override
    public void visit(Formula formula) {
        this.defaultVisit(formula);
    }

    @Override
    public void visit(Citation citation) {
        this.defaultVisit(citation);
    }

    @Override
    public void visit(Work work) {
        this.defaultVisit(work);
    }

    @Override
    public void visit(Drawing drawing) {
        ++this.position;
        this.last = drawing;
    }

    @Override
    public void visit(Unit unit) {
        ++this.position;
        this.last = unit;
    }

    @Override
    public void visit(TextPart part) {
        ++this.position;
        this.last = part;
    }

    @Override
    public void visit(Folium folium) {
        ++this.position;
        this.last = folium;
    }

    @Override
    public void visit(Quadratus quadratus) {
        ++this.position;
        this.last = quadratus;
    }

    @Override
    public void visit(Rectangulus rectangulus) {
        ++this.position;
        this.last = rectangulus;
    }

    @Override
    public void visit(Comment comment) {
        ++this.position;
        this.last = comment;
    }

    @Override
    public void visit(Text text) {
        this.position += text.getTextLength();
        if (this.position >= this.offset) {
            if (this.foundNode == null) {
                this.foundNode = text;
            }
            if (this.position > this.offset) {
                this.next = text;
            }
        } else {
            this.last = text;
        }
    }

    @Override
    public void visit(Image image) {
        ++this.position;
        this.last = image;
    }

    @Override
    public void visit(ComputeAction action) {
        this.defaultVisit(action);
    }

    @Override
    public void visit(StraightLineAction straightLineAction) {
    }

    @Override
    public void visit(StraightLineDirectionAction straightLineDirectionAction) {
    }
}

