/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.scriptorium.ecomponents.drawing.styles;

import java.io.File;
import java.net.URI;
import org.homelinux.elabor.scriptorium.ecomponents.ComponentFactory;
import org.homelinux.elabor.scriptorium.ecomponents.EditionComponent;
import org.homelinux.elabor.scriptorium.ecomponents.EditionComposite;
import org.homelinux.elabor.scriptorium.ecomponents.visitors.EditionVisitor;
import org.w3c.dom.Element;

public class StyleSetReference
extends EditionComposite<StyleSetReference>
implements ComponentFactory<StyleSetReference> {
    private static final String PATH_ATTRIBUTE = "path";

    public StyleSetReference() {
    }

    public StyleSetReference(Element element) {
        super(element);
    }

    public StyleSetReference(EditionComponent<?> parent) {
        super(parent);
    }

    @Override
    public String getElementName() {
        return "styleset";
    }

    @Override
    public void accept(EditionVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public StyleSetReference make(Element element) {
        return new StyleSetReference(element);
    }

    public void setUri(URI fileURI) {
        this.setStringAttribute(PATH_ATTRIBUTE, fileURI.toString());
    }

    public File getFile(File folder) {
        File file;
        URI folderUri = folder.toURI();
        String fileName = this.getStringAttribute(PATH_ATTRIBUTE);
        if (fileName.isEmpty()) {
            file = null;
        } else {
            URI fileURI = folderUri.resolve(fileName);
            file = new File(fileURI);
        }
        return file;
    }
}

