/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.scriptorium.ecomponents.drawing.shapes;

import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import org.homelinux.elabor.scriptorium.ecomponents.ComponentFactory;
import org.homelinux.elabor.scriptorium.ecomponents.EditionListener;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.ComponentType;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.shapes.AbstractShape;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.shapes.ScriptoriumShape;
import org.homelinux.elabor.scriptorium.ecomponents.drawing.shapes.ShapeVisitor;
import org.homelinux.elabor.tools.MessageCatalog;
import org.w3c.dom.Element;

public class Line
extends AbstractShape<Line>
implements ComponentFactory<Line> {
    private String startString;
    private String pointString;

    public Line() {
        this.initLocale();
    }

    public Line(Element element) {
        super(element);
        this.initLocale();
    }

    public Line(ScriptoriumShape parent, EditionListener listener) {
        super(parent, listener);
        this.initLocale();
    }

    private void initLocale() {
        MessageCatalog catalog = new MessageCatalog();
        catalog.loadCatalog(this.getClass().getName());
        this.startString = catalog.translate("start");
        this.pointString = catalog.translate("point");
    }

    @Override
    public boolean canAddPoint() {
        return true;
    }

    @Override
    public int getNeededNumberOfPoints() {
        return 2;
    }

    @Override
    public String getPointName(int position) {
        return position == 0 ? this.startString : this.pointString;
    }

    @Override
    public Shape getShape(Point2D[] points) {
        GeneralPath line = new GeneralPath();
        if (points.length > 0) {
            line.moveTo((float)points[0].getX(), (float)points[0].getY());
            int i = 1;
            while (i < this.getPointsNumber()) {
                line.lineTo((float)points[i].getX(), (float)points[i].getY());
                ++i;
            }
        }
        return line;
    }

    @Override
    public String getElementName() {
        return ComponentType.LINE.getName();
    }

    @Override
    protected Line make(Element element) {
        return new Line(element);
    }

    @Override
    public void accept(ShapeVisitor visitor) {
        visitor.visit(this);
    }
}

