/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.scriptorium.ecomponents;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.homelinux.elabor.scriptorium.ecomponents.ComponentFactory;
import org.homelinux.elabor.scriptorium.ecomponents.Content;
import org.homelinux.elabor.scriptorium.ecomponents.EditionComponent;
import org.homelinux.elabor.scriptorium.ecomponents.EditionComposite;
import org.homelinux.elabor.scriptorium.ecomponents.Header;
import org.homelinux.elabor.scriptorium.ecomponents.Release;
import org.homelinux.elabor.scriptorium.ecomponents.ValidationException;
import org.homelinux.elabor.scriptorium.ecomponents.visitors.EditionVisitor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Edition
extends EditionComposite<Edition>
implements ComponentFactory<Edition> {
    private Document document;
    private File docFile;

    public Edition() {
        this.document = Edition.newDocument();
        this.docFile = null;
        String elementName = this.getElementName();
        Element editionElement = this.document.createElement(elementName);
        this.document.appendChild(editionElement);
        Element contentElement = this.document.createElement("content");
        editionElement.appendChild(contentElement);
        this.setElement(editionElement);
    }

    public Edition(Element element) {
        super(element);
        this.docFile = null;
        if (element.getOwnerDocument() != null) {
            this.document = element.getOwnerDocument();
        } else {
            this.document = Edition.newDocument();
            this.document.appendChild(element);
        }
    }

    private static Document newDocument() {
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        docFactory.setValidating(false);
        Document newDocument = null;
        try {
            DocumentBuilder builder = docFactory.newDocumentBuilder();
            newDocument = builder.newDocument();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
        return newDocument;
    }

    @Override
    public Document getDocument() {
        return this.document;
    }

    public void setReleaseNumber(String releaseNumber) {
        this.getRelease().setNumber(releaseNumber);
    }

    public void setTitle(String title) {
        this.getHeader().setTitle(title);
    }

    public String getTitle() {
        return this.getHeader().getTitle();
    }

    public void setFile(File docFile) {
        File oldDir = this.docFile == null ? null : this.docFile.getParentFile();
        this.relativize(oldDir, docFile.getParentFile());
        this.docFile = docFile;
    }

    public File getFile() {
        return this.docFile;
    }

    public void setDomDocument(Document document) {
        this.document = document;
        this.setElement(document.getDocumentElement());
    }

    public boolean isTextNull() {
        return this.getTextLength() == 0;
    }

    public Content getContent() throws ValidationException {
        Content content = this.getOrCreateFirstNodeByType(new Content());
        if (content.getChildren().size() == 0) {
            Element child = this.document.createElement("text");
            child.setAttribute("content", "");
            content.getElement().appendChild(child);
        }
        return content;
    }

    public Header getHeader() throws ValidationException {
        return this.getOrCreateFirstNodeByType(new Header());
    }

    public Release getRelease() throws ValidationException {
        return this.getOrCreateFirstNodeByType(new Release());
    }

    @Override
    public List<EditionComponent<?>> getChildrenForTextView() {
        ArrayList nodes = new ArrayList();
        nodes.add(this.getContent());
        return nodes;
    }

    @Override
    public void accept(EditionVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    @Deprecated
    public Edition make(Element element) {
        Edition edition = new Edition(element);
        return edition;
    }

    @Override
    public String getElementName() {
        return "edition";
    }
}

