/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.scriptorium.ecomponents;

import org.homelinux.elabor.scriptorium.ecomponents.ComponentFactory;
import org.homelinux.elabor.scriptorium.ecomponents.Description;
import org.homelinux.elabor.scriptorium.ecomponents.EditionComponent;
import org.homelinux.elabor.scriptorium.ecomponents.EditionComposite;
import org.homelinux.elabor.scriptorium.ecomponents.OntologyReference;
import org.homelinux.elabor.scriptorium.ecomponents.Reading;
import org.homelinux.elabor.scriptorium.ecomponents.ReadingReference;
import org.homelinux.elabor.scriptorium.ecomponents.ValidationException;
import org.homelinux.elabor.scriptorium.ecomponents.visitors.EditionVisitor;
import org.w3c.dom.Element;

public class DescriptionItem
extends EditionComposite<DescriptionItem>
implements ComponentFactory<DescriptionItem> {
    public DescriptionItem() {
    }

    public DescriptionItem(Description parent) {
        super(parent);
    }

    public DescriptionItem(Element element) {
        super(element);
    }

    public OntologyReference getOntologyReference() {
        return this.getFirstNodeByType(new OntologyReference());
    }

    public Reading getReading() {
        return this.getFirstNodeByType(new Reading());
    }

    public ReadingReference getReadingReference() {
        return this.getFirstNodeByType(new ReadingReference());
    }

    private void set(EditionComponent<?> edition_node) throws ValidationException {
        this.removeAllChildren();
        this.addChild(edition_node);
    }

    public void setAsOntologyReference(OntologyReference ontology_reference) throws ValidationException {
        this.set(ontology_reference);
    }

    public void setAsReading(Reading reading) throws ValidationException {
        this.set(reading);
    }

    public void setAsReadingReference(ReadingReference reading_reference) throws ValidationException {
        this.set(reading_reference);
    }

    public DescriptionItemType getType() {
        DescriptionItemType type = null;
        if (this.getOntologyReference() != null) {
            type = DescriptionItemType.ONTOLOGY_REFERENCE_TYPE;
        } else if (this.getReading() != null) {
            type = DescriptionItemType.READING_TYPE;
        } else if (this.getReadingReference() != null) {
            type = DescriptionItemType.READING_REFERENCE_TYPE;
        }
        return type;
    }

    @Override
    public String toString() {
        String ret_value = "";
        if (this.getType() != null) {
            switch (this.getType()) {
                case ONTOLOGY_REFERENCE_TYPE: {
                    ret_value = this.getOntologyReference().toString();
                    break;
                }
                case READING_TYPE: {
                    ret_value = this.getReading().toString();
                    break;
                }
                case READING_REFERENCE_TYPE: {
                    ret_value = this.getReadingReference().toString();
                }
            }
        }
        return ret_value;
    }

    @Override
    public DescriptionItem make(Element element) {
        return new DescriptionItem(element);
    }

    @Override
    public String getElementName() {
        return "descriptionitem";
    }

    @Override
    public void accept(EditionVisitor visitor) {
        visitor.visit(this);
    }

    public static enum DescriptionItemType {
        READING_TYPE,
        READING_REFERENCE_TYPE,
        ONTOLOGY_REFERENCE_TYPE;

    }
}

