/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.pdf;

import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Element;
import com.itextpdf.text.Font;
import com.itextpdf.text.Paragraph;
import java.util.HashMap;
import java.util.Map;
import org.homelinux.elabor.pdf.ImageHandler;
import org.homelinux.elabor.pdf.NodeHandler;
import org.homelinux.elabor.pdf.ParagraphAttributesHandler;
import org.homelinux.elabor.pdf.ParagraphBorderEvent;
import org.homelinux.elabor.pdf.ParamHandler;
import org.homelinux.elabor.pdf.PhraseHandler;
import org.homelinux.elabor.pdf.TextHandler;
import org.homelinux.elabor.pdf.TypedField;
import org.w3c.dom.Node;

public class ParagraphHandler {
    private static final Font FONT = new Font(Font.FontFamily.HELVETICA, 10.0f);
    private static final Map<String, NodeHandler> NODE_HANDLERS = new HashMap<String, NodeHandler>();
    private Document document;
    private Map<String, ? extends TypedField> fieldsMap;
    private Map<String, Object> valuesMap;
    private ParagraphAttributesHandler attributesHandler;

    public ParagraphHandler(Document document, Map<String, ? extends TypedField> fieldsMap, Map<String, Object> valuesMap) {
        this.document = document;
        this.fieldsMap = fieldsMap;
        this.valuesMap = valuesMap;
        this.attributesHandler = new ParagraphAttributesHandler();
    }

    public void handleParagraph(org.w3c.dom.Element element, ParagraphBorderEvent border) throws DocumentException {
        Paragraph paragraph = new Paragraph();
        paragraph.setFont(FONT);
        paragraph.setLeading(12.0f);
        paragraph.setSpacingBefore(10.0f);
        paragraph.setAlignment(3);
        this.attributesHandler.handleAttributes(paragraph, border, element);
        for (Node child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
            String name = child.getNodeName();
            NodeHandler handler = NODE_HANDLERS.get(name);
            handler.handle(paragraph, this.valuesMap, this.fieldsMap, child);
        }
        this.document.add((Element)paragraph);
    }

    static {
        NODE_HANDLERS.put("#text", new TextHandler());
        NODE_HANDLERS.put("param", new ParamHandler(FONT));
        NODE_HANDLERS.put("phrase", new PhraseHandler());
        NODE_HANDLERS.put("image", new ImageHandler());
    }
}

