/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.pdf;

import com.itextpdf.text.Phrase;
import org.homelinux.elabor.pdf.AttributeHandler;
import org.homelinux.elabor.pdf.AttributesHandler;
import org.homelinux.elabor.pdf.ParagraphBorderEvent;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public abstract class AbstractAttributesHandler<P extends Phrase>
implements AttributesHandler<P> {
    @Override
    public void handleAttributes(P phrase, ParagraphBorderEvent border, Element element) {
        if (border != null) {
            border.setActive(false);
        }
        NamedNodeMap attributes = element.getAttributes();
        for (int index = 0; index < attributes.getLength(); ++index) {
            Node attribute = attributes.item(index);
            this.handleAttribute(phrase, border, attribute);
        }
    }

    @Override
    public void handleAttribute(P phrase, ParagraphBorderEvent border, Node attribute) {
        String name = attribute.getNodeName();
        AttributeHandler<P> handler = this.getHandler(name);
        if (handler != null) {
            String value = attribute.getNodeValue();
            handler.handle(phrase, border, value);
        }
    }
}

