/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.email;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.util.ByteArrayDataSource;
import org.homelinux.elabor.email.EmailAddress;
import org.homelinux.elabor.email.EmailAttachment;
import org.homelinux.elabor.email.EmailConfiguration;
import org.homelinux.elabor.email.EmailContent;
import org.homelinux.elabor.email.EmailDisabledException;
import org.homelinux.elabor.email.EmailHandler;
import org.homelinux.elabor.email.HtmlEmailContent;
import org.homelinux.elabor.email.NullEmailHandler;
import org.homelinux.elabor.email.PasswordAuthenticator;
import org.homelinux.elabor.email.PlainEmailContent;

public class EmailHelper {
    public static void main(String[] args) throws UnsupportedEncodingException, MessagingException {
        Session session = EmailHelper.getSession("mercury.elabor.biz", "465", "elabor", "paolo", "topsecret");
        InternetAddress receiverAddress = EmailHelper.getInternetAddress("receiver", "paolo@elabor.biz");
        InternetAddress senderAddress = EmailHelper.getInternetAddress("sender", "test@elabor.biz");
        PlainEmailContent content = new PlainEmailContent("prova", "ciao");
        EmailHelper.send(session, receiverAddress, senderAddress, content);
    }

    private EmailHelper() {
    }

    public static Session getSession(EmailConfiguration configuration) throws EmailDisabledException {
        if (!configuration.isEnabled()) {
            throw new EmailDisabledException();
        }
        String host = configuration.getHost();
        String port = configuration.getPort();
        String helo = configuration.getHelo();
        String username = configuration.getUsername();
        String password = configuration.getPassword();
        Session session = username == null || username.trim().isEmpty() ? EmailHelper.getSession(host, port, helo) : EmailHelper.getSession(host, port, helo, username, password);
        return session;
    }

    public static Session getSession(String host, String port, String helo) {
        Properties configuration = new Properties();
        configuration.setProperty("mail.transport.protocol", "smtp");
        configuration.setProperty("mail.smtp.host", host);
        configuration.setProperty("mail.smtp.port", port);
        configuration.setProperty("mail.smtp.localhost", helo);
        configuration.setProperty("mail.smtp.auth", "false");
        return Session.getInstance((Properties)configuration);
    }

    public static Session getSession(String host, String port, String helo, String username, String password) {
        Properties configuration = new Properties();
        configuration.setProperty("mail.transport.protocol", "smtp");
        configuration.setProperty("mail.smtp.host", host);
        configuration.setProperty("mail.smtp.port", port);
        configuration.setProperty("mail.smtp.localhost", helo);
        configuration.setProperty("mail.smtp.auth", "true");
        configuration.setProperty("mail.smtp.ssl.enable", "true");
        configuration.setProperty("mail.smtp.ssl.protocols", "TLSv1.2");
        PasswordAuthenticator authenticator = new PasswordAuthenticator(username, password);
        return Session.getInstance((Properties)configuration, (Authenticator)authenticator);
    }

    @Deprecated
    public static void send(Session session, EmailAddress receiver, EmailAddress sender, String subject, String text, EmailHandler handler) throws MessagingException, UnsupportedEncodingException {
        InternetAddress receiverAddress = EmailHelper.getInternetAddress(receiver);
        InternetAddress senderAddress = EmailHelper.getInternetAddress(sender);
        PlainEmailContent content = new PlainEmailContent(subject, text);
        EmailHelper.send(session, receiverAddress, senderAddress, content, handler);
    }

    @Deprecated
    public static InternetAddress getInternetAddress(EmailAddress receiver) throws AddressException, UnsupportedEncodingException {
        String email = receiver.getEmail();
        InternetAddress toAddress = new InternetAddress(email, true);
        String name = receiver.getName();
        if (name != null && !name.isEmpty()) {
            toAddress.setPersonal(name);
        }
        return toAddress;
    }

    public static InternetAddress getInternetAddress(String personal, String email) throws AddressException, UnsupportedEncodingException {
        InternetAddress toAddress = new InternetAddress(email, true);
        toAddress.setPersonal(personal);
        return toAddress;
    }

    @Deprecated
    public static void sendPlain(Session session, InternetAddress receiverAddress, InternetAddress senderAddress, String subject, String text) throws MessagingException {
        PlainEmailContent content = new PlainEmailContent(subject, text);
        EmailHelper.send(session, receiverAddress, senderAddress, content, new NullEmailHandler());
    }

    @Deprecated
    public static void sendHtml(Session session, InternetAddress receiverAddress, InternetAddress senderAddress, String subject, String text) throws MessagingException {
        HtmlEmailContent content = new HtmlEmailContent(subject, text);
        EmailHelper.send(session, receiverAddress, senderAddress, content);
    }

    public static void send(Session session, InternetAddress receiverAddress, InternetAddress senderAddress, EmailContent content) throws MessagingException {
        NullEmailHandler handler = new NullEmailHandler();
        EmailHelper.send(session, receiverAddress, senderAddress, content, handler);
    }

    public static void send(Session session, InternetAddress receiverAddress, InternetAddress senderAddress, EmailContent content, EmailHandler handler) throws MessagingException {
        MimeMessage message = new MimeMessage(session);
        message.setSender((Address)senderAddress);
        message.setFrom((Address)senderAddress);
        String subject = content.getSubject();
        message.setSubject(subject);
        String text = content.getText();
        String subtype = content.getSubtype();
        message.setText(text, "UTF-8", subtype);
        if (receiverAddress != null) {
            message.addRecipient(Message.RecipientType.TO, (Address)receiverAddress);
        }
        handler.handle(message);
        Transport.send((Message)message);
    }

    public static void sendMultipart(Session session, InternetAddress toAddress, InternetAddress fromAddress, InternetAddress replyToAddress, String subject, String text, EmailAttachment attachment, EmailHandler handler) throws MessagingException, IOException {
        MimeMessage message = new MimeMessage(session);
        message.setSender((Address)fromAddress);
        message.setReplyTo((Address[])InternetAddress.parse((String)replyToAddress.getAddress()));
        message.setFrom((Address)fromAddress);
        message.setSubject(subject);
        message.addRecipient(Message.RecipientType.TO, (Address)toAddress);
        handler.handle(message);
        MimeBodyPart messageBodyPart = new MimeBodyPart();
        messageBodyPart.setText(text);
        MimeMultipart multipart = new MimeMultipart();
        multipart.addBodyPart((BodyPart)messageBodyPart);
        messageBodyPart = new MimeBodyPart();
        try (InputStream inputStream = attachment.getInputStream();){
            String mimeType = attachment.getMimeType();
            ByteArrayDataSource dataSource = new ByteArrayDataSource(inputStream, mimeType);
            DataHandler dataHandler = new DataHandler((DataSource)dataSource);
            messageBodyPart.setDataHandler(dataHandler);
            String filename = attachment.getName();
            messageBodyPart.setFileName(filename);
            multipart.addBodyPart((BodyPart)messageBodyPart);
            message.setContent((Multipart)multipart);
            Transport.send((Message)message);
        }
    }

    public static void sendHtml(Session session, InternetAddress toAddress, InternetAddress senderAddress, InternetAddress replyToAddress, String subject, String text, EmailAttachment attachment, EmailHandler handler) throws MessagingException, UnsupportedEncodingException, IOException {
        MimeMessage message = new MimeMessage(session);
        message.setSender((Address)senderAddress);
        message.setReplyTo((Address[])InternetAddress.parse((String)replyToAddress.getAddress()));
        message.setFrom((Address)senderAddress);
        message.setSubject(subject);
        message.addRecipient(Message.RecipientType.TO, (Address)toAddress);
        handler.handle(message);
        MimeMultipart multipart = new MimeMultipart();
        MimeBodyPart htmlBodyPart = new MimeBodyPart();
        htmlBodyPart.setContent((Object)text, "text/html;charset=utf-8");
        htmlBodyPart.setHeader("Content-Transfer-Encoding", "7BIT");
        multipart.addBodyPart((BodyPart)htmlBodyPart);
        htmlBodyPart = new MimeBodyPart();
        try (InputStream inputStream = attachment.getInputStream();){
            String mimeType = attachment.getMimeType();
            ByteArrayDataSource dataSource = new ByteArrayDataSource(inputStream, mimeType);
            DataHandler dataHandler = new DataHandler((DataSource)dataSource);
            htmlBodyPart.setDataHandler(dataHandler);
            String filename = attachment.getName();
            htmlBodyPart.setFileName(filename);
            multipart.addBodyPart((BodyPart)htmlBodyPart);
            message.setContent((Multipart)multipart);
            Transport.send((Message)message);
        }
    }
}

