/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.db;

import java.util.ArrayList;
import java.util.List;
import org.homelinux.elabor.db.Clause;
import org.homelinux.elabor.db.QueryBuilder;
import org.homelinux.elabor.db.SearchCriteria;

public abstract class QueryFormatter<C extends SearchCriteria> {
    protected Clause select;
    private Clause from;
    private Clause where;
    protected Clause groupby;
    protected Clause having;
    protected Clause orderby;
    protected List<QueryBuilder<C>> builders;

    public QueryFormatter() {
        this.reset();
    }

    public static boolean hasText(String text) {
        return text != null && !text.trim().isEmpty();
    }

    private void reset() {
        this.select = new Clause("SELECT");
        this.select.add("*");
        this.setFrom(new Clause("FROM"));
        this.setWhere(new Clause("WHERE", "AND"));
        this.groupby = new Clause("GROUP BY");
        this.having = new Clause("HAVING", "AND");
        this.orderby = new Clause("ORDER BY");
        this.builders = new ArrayList<QueryBuilder<C>>();
    }

    public abstract void prepareBuilders(C var1);

    public String build(C criteria, String clause) {
        this.reset();
        if (clause != null) {
            this.orderby.set(clause);
        }
        this.prepareBuilders(criteria);
        for (QueryBuilder<C> builder : this.builders) {
            builder.join(this);
            builder.compose(criteria, this);
        }
        return this.pack();
    }

    public String build(C criteria) {
        return this.build(criteria, null);
    }

    private String pack() {
        String query = this.select.toString() + this.getFrom().toString();
        if (!this.getWhere().isEmpty()) {
            query = query + this.getWhere().toString();
        }
        if (!this.groupby.isEmpty()) {
            query = query + this.groupby.toString();
        }
        if (!this.having.isEmpty()) {
            query = query + this.having.toString();
        }
        if (!this.orderby.isEmpty()) {
            query = query + this.orderby.toString();
        }
        return query;
    }

    public void setFrom(Clause from) {
        this.from = from;
    }

    public Clause getFrom() {
        return this.from;
    }

    public void setWhere(Clause where) {
        this.where = where;
    }

    public Clause getWhere() {
        return this.where;
    }
}

