/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.csv;

import java.util.ArrayList;
import org.homelinux.elabor.csv.LineParser;

public class CsvLineParser
implements LineParser {
    @Override
    public String[] parse(String line, char delimiter) {
        boolean openQuote = false;
        ArrayList<String> list = new ArrayList<String>();
        int start = 0;
        int length = line.length();
        for (int index = 0; index < length; ++index) {
            char c = line.charAt(index);
            if (c == '\"' && !openQuote && start == index) {
                openQuote = true;
                continue;
            }
            if (c == '\"' && openQuote && (index == length - 1 || line.charAt(index + 1) == delimiter)) {
                openQuote = false;
                continue;
            }
            if (c != delimiter || openQuote) continue;
            String value = line.substring(start, index);
            String cleanValue = CsvLineParser.cleanQuote(value.trim());
            list.add(cleanValue);
            start = index + 1;
        }
        if (start < length) {
            String field = line.substring(start).trim();
            field = CsvLineParser.cleanQuote(field);
            list.add(field);
        } else if (start == length) {
            list.add("");
        }
        return list.toArray(new String[1]);
    }

    private static String cleanQuote(String value) {
        String cleaned = "";
        int length = value.length();
        if (length > 0) {
            char c = value.charAt(length - 1);
            cleaned = value.charAt(0) == '\"' && c == '\"' ? value.substring(1, length == 1 ? 1 : length - 1) : value;
        }
        return cleaned;
    }
}

