/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.calendar;

import java.util.Iterator;
import org.homelinux.elabor.calendar.ElaborCalendar;
import org.homelinux.elabor.calendar.Month;
import org.homelinux.elabor.calendar.MonthIterator;

public class MonthIterable
implements Iterable<Month> {
    private int year;
    private Month start;
    private Month end;

    public MonthIterable() {
        this(new ElaborCalendar().getAnno());
    }

    public MonthIterable(int year) {
        this(Month.JANUARY, year);
    }

    public MonthIterable(Month start, int year) {
        this(start, Month.DECEMBER, year);
    }

    public MonthIterable(Month start, Month end, int year) {
        this.year = year;
        this.start = start;
        this.end = end;
    }

    @Override
    public Iterator<Month> iterator() {
        return new MonthIterator(this.start, this.end, this.year);
    }

    public int getYear() {
        return this.year;
    }
}

